package zápisbin;

import java.io.*;

public class ZápisBin 
{
    public static void zapišPoleDoSouboru(int[] pole, String jméno) throws IOException
    {
        try(var výstup = new DataOutputStream(new FileOutputStream(jméno)))
        {
            for(var prvek: pole)
            {
                výstup.writeInt(prvek);
            }
        }
    }
    
    public static int[] načtiPoleZeSouboru(String jméno) throws IOException
    {
        int [] pole = null;
        File soubor = new File(jméno);
        if(!soubor.exists())
        {
            throw new IOException("Soubor neexistuje");
        }
        try(var vstup = new DataInputStream(new FileInputStream(jméno)))
        {
            int délka  = (int)soubor.length()/(Integer.SIZE/8);
            pole = new int[délka];
            for(int i = 0; i < délka; i++)
            {
                pole[i] = vstup.readInt();
            }
            return pole;
        }
    }
    
    public static void main(String[] args) throws IOException 
    {
//        int A[]= {1,2,3,4,5,6,7,8,9,10};
//        zapišPoleDoSouboru(A, "data1.dta");
        int [] B = načtiPoleZeSouboru("data1.dta");
        for(int i: B)
        {
            System.out.print(i + " ");
        }
    }
    
    
}
